//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPreferencesDlg, CTreePropSheet)

BEGIN_MESSAGE_MAP(CPreferencesDlg, CTreePropSheet)
	ON_WM_DESTROY()
END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndScheduler.m_psp.dwFlags &= ~PSH_HASHELP;

//==> PPgTabControl [shadow2004]
	m_wndDisplay2.m_psp.dwFlags &= ~PSH_HASHELP;			//Extended
	m_wndConnection2.m_psp.dwFlags &= ~PSH_HASHELP;			//Hardlimit
	m_wndConnection3.m_psp.dwFlags &= ~PSH_HASHELP;			//V Limit
	m_wndFiles2.m_psp.dwFlags &= ~PSH_HASHELP;			//Drop
	m_wndSecurity2.m_psp.dwFlags &= ~PSH_HASHELP;			//IPFilter
//<== PPgTabControl [shadow2004]

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_wndDebug.m_psp.dwFlags &= ~PSH_HASHELP;
#endif

	CTreePropSheet::SetPageIcon(&m_wndGeneral, _T("Preferences"));
	CTreePropSheet::SetPageIcon(&m_wndDisplay, _T("DISPLAY"));
	CTreePropSheet::SetPageIcon(&m_wndConnection, _T("CONNECTION"));
	CTreePropSheet::SetPageIcon(&m_wndServer, _T("SERVER"));
	CTreePropSheet::SetPageIcon(&m_wndDirectories, _T("FOLDERS"));
	CTreePropSheet::SetPageIcon(&m_wndFiles, _T("Transfer"));
	CTreePropSheet::SetPageIcon(&m_wndNotify, _T("NOTIFICATIONS"));
	CTreePropSheet::SetPageIcon(&m_wndStats, _T("STATISTICS"));
	CTreePropSheet::SetPageIcon(&m_wndMessages, _T("MESSAGES"));
	CTreePropSheet::SetPageIcon(&m_wndSecurity, _T("SECURITY"));
	CTreePropSheet::SetPageIcon(&m_wndScheduler, _T("SCHEDULER"));
	CTreePropSheet::SetPageIcon(&m_wndWebServer, _T("WEB"));
	CTreePropSheet::SetPageIcon(&m_wndTweaks, _T("TWEAK"));
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CTreePropSheet::SetPageIcon(&m_wndDebug, _T("Preferences"));
#endif

	AddPage(&m_wndGeneral);			// 0
	AddPage(&m_wndDisplay);			// 1
	AddPage(&m_wndConnection);		// 2
	AddPage(&m_wndServer);			// 3
	AddPage(&m_wndDirectories);		// 4
	AddPage(&m_wndFiles);			// 5
	AddPage(&m_wndNotify);			// 6
	AddPage(&m_wndStats);			// 7
	AddPage(&m_wndMessages);		// 8
	AddPage(&m_wndSecurity);		// 9
	AddPage(&m_wndScheduler);		// 10
	AddPage(&m_wndWebServer);		// 11
	AddPage(&m_wndTweaks);			// 12

//==> PPgTabControl [shadow2004]
	AddPage(&m_wndDisplay2);               // 13							
	AddPage(&m_wndConnection2);	       // 14						
	AddPage(&m_wndConnection3);	       // 15						
	AddPage(&m_wndFiles2);			// 16						
	AddPage(&m_wndSecurity2);		// 17						
//<== PPgTabControl [shadow2004]

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);                  // 18
#endif

	// The height of the option dialog is already too large for 640x480. To show as much as
	// possible we do not show a page caption (which is an decorative element only anyway).
	SetTreeViewMode(TRUE, GetSystemMetrics(SM_CYSCREEN) >= 600, TRUE);
	SetTreeWidth(170);

	m_pPshStartPage = NULL;
	m_bSaveIniFile = false;
//==> PPgTabControl [shadow2004]
	ActivePageGeneral			= 0;
	ActivePageDisplay			= 0;
	ActivePageConnection		        = 0;
	ActivePageServer			= 0;
	ActivePageDirectory			= 0;
	ActivePageFiles				= 0;
	ActivePageNotify			= 0;
	ActivePageStats				= 0;
	ActivePageMessages			= 0;
	ActivePageSecurity			= 0;
	ActivePageScheduler			= 0;
	ActivePageWebServer			= 0;
//	ActivePageTweaks			= 0;
	ActivePageDebug				= 0;

        StartPageGeneral			= 0;
	StartPageDisplay			= 0;
	StartPageConnection			= 0;
	StartPageServer				= 0;
	StartPageDirectory			= 0;
	StartPageFiles				= 0;
	StartPageNotify				= 0;
	StartPageStats				= 0;
	StartPageMessages			= 0;
	StartPageScheduler			= 0;
	StartPageWebServer			= 0;
//	StartPageTweaks				= 0;
	StartPageDebug				= 0;
//<== PPgTabControl [shadow2004]
}

CPreferencesDlg::~CPreferencesDlg()
{
}

void CPreferencesDlg::OnDestroy()
{
	CTreePropSheet::OnDestroy();

	if (m_bSaveIniFile){
		thePrefs.Save();
		m_bSaveIniFile = false;
	}
	m_pPshStartPage = GetPage(GetActiveIndex())->m_psp.pszTemplate;
}

BOOL CPreferencesDlg::OnInitDialog()
{
	ASSERT( !m_bSaveIniFile );
	BOOL bResult = CTreePropSheet::OnInitDialog();
	InitWindowStyles(this);

//==> PPgTabControl [shadow2004]
	int nPage = 0;
//<== PPgTabControl [shadow2004]
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		if (GetPage(i)->m_psp.pszTemplate == m_pPshStartPage)
		{

//==> PPgTabControl [shadow2004]

			if (i>=13)
			{
				if (i == 13) 
				{	// Display2			Extended
					SetActivePage(1);
			    }

				if (i == 14) 
				{	// Connection2		Hardlimit
					SetActivePage(2);
			    }

				if (i == 15) 
				{	// Connection3		V Limit
					SetActivePage(2);
			    }

				if (i == 16) 
				{	// Files2			Drop
					SetActivePage(5);
			    }
				
				if (i == 17) 
				{	// Security2		IPFilter
					SetActivePage(8);
			    }

				m_wndDisplay.InitTab(false,StartPageDisplay);
				m_wndDisplay2.InitTab(false,StartPageDisplay);
				m_wndConnection.InitTab(false,StartPageConnection);
				m_wndConnection2.InitTab(false,StartPageConnection);
				m_wndConnection3.InitTab(false,StartPageConnection);
				m_wndFiles.InitTab(false,StartPageFiles);
				m_wndFiles2.InitTab(false,StartPageFiles);
				m_wndSecurity.InitTab(false,StartPageSecurity);
				m_wndSecurity2.InitTab(false,StartPageSecurity);

				break;
			}
			else
			{
			SetActivePage(i);
			break;
		}

//<== PPgTabControl [shadow2004]

		}
	}

	Localize();	
	return bResult;
}

void CPreferencesDlg::Localize()
{
	SetTitle(RemoveAmbersand(GetResString(IDS_EM_PREFS))); 

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndMessages.Localize();
	m_wndNotify.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndWebServer.Localize();
	m_wndScheduler.Localize();

//==> PPgTabControl [shadow2004]
	m_wndDisplay2.Localize();
	m_wndConnection2.Localize();
	m_wndConnection3.Localize();
	m_wndFiles2.Localize();
	m_wndSecurity2.Localize();
//<== PPgTabControl [shadow2004]

	int c = 0;

	CTreeCtrl* pTree = GetPageTreeControl();
	if (pTree)
	{
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_GENERAL)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_DISPLAY))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_CONNECTION))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_SERVER))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_DIR))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_FILES))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_EKDEV_OPTIONS))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_STATSSETUPINFO))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_MESSAGESCOMMENTS)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_SECURITY))); 
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_SCHEDULER)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_WS)));
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(GetResString(IDS_PW_TWEAK)));
//==> PPgTabControl [shadow2004]
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(_T(" ")));	//Extended
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(_T(" ")));	//HardLimit
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(_T(" ")));	//V Limit
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(_T(" ")));	//Drop
		pTree->SetItemText(GetPageTreeItem(c++), RemoveAmbersand(_T(" ")));	//IPFilter
//<== PPgTabControl [shadow2004]

	#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
		pTree->SetItemText(GetPageTreeItem(c++), _T("Debug"));
	#endif
	}

	UpdateCaption();
}


void CPreferencesDlg::SetStartPage(UINT uStartPageID)
{
	m_pPshStartPage = MAKEINTRESOURCE(uStartPageID);
}

//==> PPgTabControl [shadow2004]
void CPreferencesDlg::SwitchTab(int Page)
{
	
	if(m_hWnd && IsWindowVisible()){
		CPropertyPage* activepage = GetActivePage();

		// General 1
		if (activepage == &m_wndGeneral ){
			if (Page == 0) {
				SetActivePage(&m_wndGeneral);
				ActivePageGeneral = 0;
				StartPageGeneral = 0;
				m_wndGeneral.InitTab(false,0);
			}
		}
		
		// Display 1-2
		if (activepage == &m_wndDisplay || activepage == &m_wndDisplay2 ){
			if (Page == 0) {
				SetActivePage(&m_wndDisplay);
				ActivePageDisplay = 0;
				StartPageDisplay = 0;
				m_wndDisplay.InitTab(false,0);
			}
			if (Page == 1) {
				SetActivePage(&m_wndDisplay2);
				ActivePageDisplay = 13;
				StartPageDisplay = 1;
				m_wndDisplay2.InitTab(false,1);
			}
		}

		// Connection 1-3
		if (activepage == &m_wndConnection || activepage == &m_wndConnection2 || activepage == &m_wndConnection3 ){
			if (Page == 0) {
				SetActivePage(&m_wndConnection);
				ActivePageConnection = 0;
				StartPageConnection = 0;
				m_wndConnection.InitTab(false,0);
			}
			if (Page == 1) {
				SetActivePage(&m_wndConnection2);
				ActivePageConnection = 14;
				StartPageConnection = 1;
				m_wndConnection2.InitTab(false,1);
			}
			if (Page == 2) {
				SetActivePage(&m_wndConnection3);
				ActivePageConnection = 15;
				StartPageConnection = 2;
				m_wndConnection3.InitTab(false,2);
			}

		}

		// Directory 1
		if (activepage == &m_wndDirectories ){
			if (Page == 0) {
				SetActivePage(&m_wndDirectories);
				ActivePageDirectory = 0;
				StartPageDirectory = 0;
				m_wndDirectories.InitTab(false,0);
			}
		}

		// Files 1
		if (activepage == &m_wndFiles || activepage == &m_wndFiles2 ){
			if (Page == 0) {
				SetActivePage(&m_wndFiles);
				ActivePageFiles = 0;
				StartPageFiles = 0;
				m_wndFiles.InitTab(false,0);
			}
			if (Page == 1) {
				SetActivePage(&m_wndFiles2);
				ActivePageFiles = 16;
				StartPageFiles = 5;
				m_wndFiles2.InitTab(false,1);
			}

		}

		// Notify 1
		if (activepage == &m_wndNotify ){
			if (Page == 0) {
				SetActivePage(&m_wndNotify);
				ActivePageNotify = 0;
				StartPageNotify = 0;
				m_wndNotify.InitTab(false,0);
			}
		}

		// Stats 1
		if (activepage == &m_wndStats ){
			if (Page == 0) {
				SetActivePage(&m_wndStats);
				ActivePageStats = 0;
				StartPageStats = 0;
				m_wndStats.InitTab(false,0);
			}
		}

		// Messages 1
		if (activepage == &m_wndMessages ){
			if (Page == 0) {
				SetActivePage(&m_wndMessages);
				ActivePageMessages = 0;
				StartPageMessages = 0;
				m_wndMessages.InitTab(false,0);
			}
		}

		// Security 1-2
		if (activepage == &m_wndSecurity || activepage == &m_wndSecurity2 ){
			if (Page == 0) {
				SetActivePage(&m_wndSecurity);
				ActivePageSecurity = 0;
				StartPageSecurity = 0;
				m_wndSecurity.InitTab(false,0);
			}
			if (Page == 1) {
				SetActivePage(&m_wndSecurity2);
				ActivePageSecurity = 17;
				StartPageSecurity = 1;
				m_wndSecurity2.InitTab(false,1);
			}
		}

		// Scheduler 1
		if (activepage == &m_wndScheduler ){
			if (Page == 0) {
				SetActivePage(&m_wndScheduler);
				ActivePageScheduler = 0;
				StartPageScheduler = 0;
				m_wndScheduler.InitTab(false,0);
			}
		}
		
		// WebServer 1
		if (activepage == &m_wndWebServer ){
			if (Page == 0) {
				SetActivePage(&m_wndWebServer);
				ActivePageWebServer = 0;
				StartPageWebServer = 0;
				m_wndWebServer.InitTab(false,0);
			}
		}
	}
}
//<== PPgTabControl [shadow2004]
